Marginal_density_mu_alpha_beta = function(x, mu, alpha, beta){
res = gamma(alpha + 1/2) / (gamma(alpha) * sqrt(2 * pi * beta)) * (1 + (x - mu)^2 / (2 * beta))^(- alpha - 1/2)
}

Marginal_density = function(x){
res = gamma(alpha + 1/2) / (gamma(alpha) * sqrt(2 * pi * Beta)) * (1 + (x - mu)^2 / (2 * Beta))^(- alpha - 1/2)
}

p_N_IG_mu_alpha_beta = function(x, mu, alpha, Beta){
mu <<- mu
alpha <<- alpha
Beta <<- Beta
	
L_x = length(x)
I_value = I_abs_error = numeric(L_x)
for (i in 1:L_x){
	I_i = integrate(f = Marginal_density, lower = - Inf, upper = x[i])
	I_value[i] = I_i$value
	I_abs_error[i] = I_i$abs.error
}

res = I_value
}

Moment_estimators = function(x){
n = length(x)
A1 = mean(x)
A2 = mean(x^2)
A4 = mean(x^4)

mu_1 = A1
alpha_1 = (2 * A4 - 3 * A2^2 - 6 * A2 * A1^2 + 7 * A1^4) / (A4 - 3 * A2^2 + 2 * A1^4)
beta_1 = (A4 - 6 * A2 * A1^2 + 5 * A1^4) * (A2 - A1^2) / (A4 - 3 * A2^2 + 2 * A1^4)

res = c(mu_1, alpha_1, beta_1)
}

data_outline = function(x){
   n = length(x)
   m = mean(x)
   v = var(x)
   s = sd(x)
   me = median(x)
   cv = 100*s/m
   css = sum((x-m)^2)
   uss = sum(x^2)
   R =  max(x)-min(x)
   R1 = quantile(x, 3/4)-quantile(x, 1/4)
   sm = s/sqrt(n)
   g1 = n/((n-1)*(n-2))*sum((x-m)^3)/s^3
   g2 = ((n*(n+1))/((n-1)*(n-2)*(n-3))*sum((x-m)^4)/s^4
          - (3*(n-1)^2)/((n-2)*(n-3)))
   data.frame(N=n, Mean=m, Var=v, std_dev=s, Median=me, 
        std_mean=sm, CV=cv, CSS=css, USS=uss, R=R, 
        R1=R1, Skewness=g1, Kurtosis=g2, row.names=1)
}

Pearson_chisquare_test = function(nn, p, r){
# nn - frequencies
# p  - theoretical probabilities
# r  - number of unknown parameters

n = sum(nn)
m = length(nn)
K = sum((nn - n * p)^2 / (n * p))
df = m - 1 - r
P_value = 1 - pchisq(K, df = df)

res = data.frame(Chisquare = K, P_value = P_value, df = df, m = m, n = n)
}

Newtons = function(fun, p, x, ep=1e-5, it_max=20){
    index = 0; k = 1
    while (k <= it_max){
        p1 = p; obj = fun(p, x);
        p  = p - solve(obj$J, obj$f);
        norm = sqrt((p-p1) %*% (p-p1))
        if (norm < ep){
            index = 1; break
        }
        k = k + 1
    }
    obj = fun(p, x);
    list(root=p, it=k, index=index, FunVal=obj$f)
}

moment_fun = function(p, x){
mu = p[1]
alpha = p[2]
beta = p[3]

f1 = (2 * alpha + 1) * mean((x - mu) / (2 * beta + (x - mu)^2))
f2 = digamma(alpha + 1/2) - digamma(alpha) + log(2 * beta) - mean(log(2 * beta + (x - mu)^2))
f3 = alpha / beta - (2 * alpha + 1) * mean(1 / (2 * beta + (x - mu)^2))
f = c(f1, f2, f3)

J11 = (2 * alpha + 1) * mean((-(2 * beta + (x - mu)^2) + 2 * (x - mu)^2) / (2 * beta + (x - mu)^2)^2)
J12 = mean(2 * (x - mu) / (2 * beta + (x - mu)^2))
J13 = (2 * alpha + 1) * mean(-2 * (x - mu) / (2 * beta + (x - mu)^2)^2)
J21 = J12
J22 = trigamma(alpha + 1/2) - trigamma(alpha)
J23 = 1 / beta - mean(2 / (2 * beta + (x - mu)^2))
J31 = J13
J32 = J23
J33 = -alpha / beta^2 + (2 * alpha + 1) * mean(2 / (2 * beta + (x - mu)^2)^2)
J = matrix(c(J11, J12, J13,
			 J21, J22, J23,
			 J31, J32, J33), nrow=3, byrow = TRUE)
			 
res = list(f=f, J=J)
}

Compute_Estimators_PESLs = function(mu, alpha, beta, x){
n = length(x)
alpha1 = alpha + n / 2
beta1 = beta + sum((x - mu)^2) / 2

delta_s = beta1 / alpha1
delta_2 = beta1 / (alpha1 - 1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = data.frame(
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_PostDist_Estimators_PESLs_new = function(mu, alpha, beta, x_np1){
alpha1 = alpha + 1 / 2
beta1 = beta + (x_np1 - mu)^2 / 2

PostDist_theta = 1 / rgamma(n = 1e4, shape = alpha1, rate = beta1)
delta_s = beta1 / alpha1
delta_2 = beta1 / (alpha1 - 1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = list(
PostDist_theta = PostDist_theta,
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_Estimators_PESLs_new = function(mu, alpha, beta, x_np1){
alpha1 = alpha + 1 / 2
beta1 = beta + (x_np1 - mu)^2 / 2

delta_s = beta1 / alpha1
delta_2 = beta1 / (alpha1 - 1)
PESL_s = log(alpha1) - digamma(alpha1)
PESL_2 = 1 / (alpha1 - 1) + log(alpha1 - 1) - digamma(alpha1)

res = data.frame(
delta_s = delta_s, 
delta_2 = delta_2, 
PESL_s = PESL_s,
PESL_2 = PESL_2
)
}

Compute_mean_variance = function(mu, alpha, beta){
E = mu
V = beta / (alpha - 1)

res = data.frame(Expectation = E, Variance = V)
}

Compute_MEE = function(theta_hat, theta){
res = mean(theta_hat/theta - 1 - log(theta_hat/theta))
}

Generate_Matrix_Latex = function(A){
m = nrow(A)
n = ncol(A)

C = rep("c", n, sep=""); C
temp = "[c]{"
for (i in 1:n){
temp = paste(temp, C[i], sep="")
}
temp = paste(temp, "}", sep="")

B = matrix("0", nrow = m, ncol = 2*n); B
for (i in 1:m){
	for (j in 1:n){
		B[i, 2*j-1] = A[i, j]
		B[i, 2*j]   = "&"
	}
}
B[, 2*n] = "\\\\"
B[m, 2*n] = ""
B

One = "\\begin{tabular}"
Two = temp
Three = B
Four = "\\end{tabular}"

cat(One, "\n", Two, "\n"); for (i in 1:m) cat(B[i, ], "\n");  cat(Four, "\n")
}

plot_estimator = function(delta_s, delta_2, parameter, para_name, xlab, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(delta_s, delta_2)
#ylim=c(0:1)
plot(parameter, delta_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "Estimator", sub = sub)
lines(parameter, delta_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, delta_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("delta_s", "delta_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-IG_Estimator_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/N-IG_Estimator_", para_name, "_change", sep = ""), type = c("jpg"))
}

plot_PESL = function(PESL_s, PESL_2, parameter, para_name, xlab, legend_pos = "topleft", sub){
dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(parameter)
ylim = range(PESL_s, PESL_2)
plot(parameter, PESL_s, type = "n", xlim = xlim, ylim = ylim, xlab = xlab, ylab = "PESL", sub = sub)
lines(parameter, PESL_s, lty = lty[1], col = col[1], lwd = 4)
lines(parameter, PESL_2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("PESL_s", "PESL_2")
legend(x = legend_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/N-IG_PESL_", para_name, "_change", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/N-IG_PESL_", para_name, "_change", sep = ""), type = c("jpg"))
}

plot_delta_PESL = function(x, y_oracle, y_MLE, y_moment, ylab, leg_pos, fig_name, sub){
dev.new()
col = c("red", "purple", "blue")
lty = 1:3
xlim = range(x)
ylim = range(y_oracle, y_MLE, y_moment)
plot(x,  y_oracle, type = "n", xlim = xlim, ylim = ylim + c(0, 0.005), xlab = expression(m), ylab = ylab, sub = sub)
lines(x, y_oracle,  lty = lty[1], col = col[1], lwd = 4)
lines(x, y_MLE,     lty = lty[2], col = col[2], lwd = 4)
lines(x, y_moment,  lty = lty[3], col = col[3], lwd = 4)
# title(Title)
leg.txt = c("oracle", "mle", "moment")
legend(x = leg_pos, legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/", fig_name, sep=""), type = c("pdf"))
savePlot(filename = paste("figure/", fig_name, sep=""), type = c("jpg"))
}

Compute_Proportions_2vectors_pmin = function(v1, v2){
min_v = pmin(v1, v2)
Proportions = numeric(2)
Proportions[1] = mean(v1 == min_v) 
# Proportions[2] = mean(v2 == min_v) 
Proportions[2] = 1 - Proportions[1] # to avoid several minimums

res = Proportions
}

Compute_Proportions_vector_pmin = function(v1, v2, v3){
min_v = pmin(v1, v2, v3)
Proportions = numeric(3)
Proportions[1] = mean(v1 == min_v) 
Proportions[2] = mean(v2 == min_v) 
# Proportions[3] = mean(v3 == min_v) 
Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several minimums

res = Proportions
}

Compute_Proportions_vector_pmax = function(v1, v2, v3){
max_v = pmax(v1, v2, v3)
Proportions = numeric(3)
Proportions[1] = mean(v1 == max_v) 
Proportions[2] = mean(v2 == max_v) 
# Proportions[3] = mean(v3 == max_v) 
Proportions[3] = 1 - Proportions[1] - Proportions[2] # to avoid several maximums

res = Proportions
}


